/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.config.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.FileUtils;
import tschipp.carryon.config.AnnotationData;
import tschipp.carryon.config.BuiltCategory;
import tschipp.carryon.config.BuiltConfig;
import tschipp.carryon.config.PropertyData;
import tschipp.carryon.config.PropertyType;

public class ConfigLoaderImpl {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    public static final Map<JsonObject, BuiltConfig> CONFIGS = new LinkedHashMap<JsonObject, BuiltConfig>();

    public static void initialize() throws IOException {
        Path cfgPath = FabricLoader.getInstance().getConfigDir();
        for (Map.Entry<JsonObject, BuiltConfig> entry : CONFIGS.entrySet()) {
            File cfgFile = new File(cfgPath.toFile(), entry.getValue().fileName + ".json");
            if (!cfgFile.exists()) {
                cfgPath.toFile().mkdirs();
                FileUtils.write((File)cfgFile, (CharSequence)GSON.toJson((JsonElement)entry.getKey()), (Charset)StandardCharsets.UTF_8);
                continue;
            }
            JsonObject cfgJson = (JsonObject)GSON.fromJson(FileUtils.readFileToString((File)cfgFile, (Charset)StandardCharsets.UTF_8), JsonObject.class);
            if (cfgJson == null) {
                cfgPath.toFile().mkdirs();
                FileUtils.write((File)cfgFile, (CharSequence)GSON.toJson((JsonElement)entry.getKey()), (Charset)StandardCharsets.UTF_8);
            }
            FileUtils.write((File)cfgFile, (CharSequence)GSON.toJson((JsonElement)ConfigLoaderImpl.loadConfig(entry.getValue(), cfgJson)), (Charset)StandardCharsets.UTF_8);
        }
    }

    private static JsonObject loadConfig(BuiltCategory category, JsonObject config) {
        config.entrySet().forEach(entry -> {
            String id = (String)entry.getKey();
            if (!id.startsWith("//")) {
                JsonElement value = (JsonElement)entry.getValue();
                if (value instanceof JsonPrimitive) {
                    JsonPrimitive configValue = (JsonPrimitive)value;
                    category.getProperty(id).ifPresent(data -> {
                        if (configValue.isBoolean() && data.getData().type().equals((Object)PropertyType.BOOLEAN)) {
                            data.setBoolean(configValue.getAsBoolean());
                        }
                        if (configValue.isNumber() && data.getData().type().equals((Object)PropertyType.INT)) {
                            int configInt = configValue.getAsInt();
                            if (configInt > data.getData().max() || configInt < data.getData().min()) {
                                try {
                                    config.addProperty(id, (Number)data.getInt());
                                }
                                catch (IllegalAccessException illegalAccessException) {}
                            } else {
                                data.setInt(configInt);
                            }
                        }
                        if (configValue.isNumber() && data.getData().type().equals((Object)PropertyType.DOUBLE)) {
                            double configDouble = configValue.getAsDouble();
                            if (configDouble > data.getData().maxD() || configDouble < data.getData().minD()) {
                                try {
                                    config.addProperty(id, (Number)data.getDouble());
                                }
                                catch (IllegalAccessException illegalAccessException) {}
                            } else {
                                data.setDouble(configDouble);
                            }
                        }
                    });
                } else if (value instanceof JsonObject) {
                    JsonObject subConfig = (JsonObject)value;
                    category.getCategory(id).ifPresent(cat -> ConfigLoaderImpl.loadConfig(cat, subConfig));
                } else if (value instanceof JsonArray) {
                    JsonArray list = (JsonArray)value;
                    category.getProperty(id).ifPresent(data -> {
                        if (data.getData().type() == PropertyType.STRING_ARRAY) {
                            ArrayList<String> ls = new ArrayList<String>();
                            for (JsonElement arrEle : list) {
                                JsonPrimitive p;
                                if (!(arrEle instanceof JsonPrimitive) || !(p = (JsonPrimitive)arrEle).isString()) continue;
                                ls.add(p.getAsString());
                            }
                            data.setStringArray(ls.toArray(new String[ls.size()]));
                        }
                    });
                }
            }
        });
        return config;
    }

    public static void saveConfigs() {
        try {
            Path cfgPath = FabricLoader.getInstance().getConfigDir();
            for (Map.Entry<JsonObject, BuiltConfig> entry : CONFIGS.entrySet()) {
                File cfgFile = new File(cfgPath.toFile(), entry.getValue().fileName + ".json");
                cfgPath.toFile().mkdirs();
                FileUtils.write((File)cfgFile, (CharSequence)GSON.toJson((JsonElement)entry.getKey()), (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerConfig(BuiltConfig config) {
        try {
            JsonObject configJson = new JsonObject();
            for (PropertyData property : config.properties) {
                ConfigLoaderImpl.buildProperty(configJson, property);
            }
            for (BuiltCategory category : config.categories) {
                ConfigLoaderImpl.buildCategory(configJson, category);
            }
            CONFIGS.put(configJson, config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void buildCategory(JsonObject builder, BuiltCategory category) throws IllegalAccessException {
        JsonObject categoryJson = new JsonObject();
        if (category.categoryDesc != null) {
            categoryJson.addProperty("//" + category.category, category.categoryDesc);
        }
        for (PropertyData property : category.properties) {
            ConfigLoaderImpl.buildProperty(categoryJson, property);
        }
        for (BuiltCategory builtCategory : category.categories) {
            ConfigLoaderImpl.buildCategory(categoryJson, builtCategory);
        }
        builder.add(category.category, (JsonElement)categoryJson);
    }

    private static void buildProperty(JsonObject builder, PropertyData data) throws IllegalAccessException {
        AnnotationData annotationData = data.getData();
        builder.addProperty("//" + data.getId(), annotationData.description());
        switch (annotationData.type()) {
            case BOOLEAN: {
                builder.addProperty(data.getId(), Boolean.valueOf(data.getBoolean()));
                data.setSetter(b -> {
                    builder.addProperty(data.getId(), Boolean.valueOf((Boolean)b));
                    data.setBoolean((Boolean)b);
                });
                break;
            }
            case INT: {
                builder.addProperty(data.getId(), (Number)data.getInt());
                data.setSetter(b -> {
                    builder.addProperty(data.getId(), (Number)((Integer)b));
                    data.setInt((Integer)b);
                });
                break;
            }
            case DOUBLE: {
                builder.addProperty(data.getId(), (Number)data.getDouble());
                data.setSetter(b -> {
                    builder.addProperty(data.getId(), (Number)((Double)b));
                    data.setDouble((Double)b);
                });
                break;
            }
            case STRING_ARRAY: {
                JsonArray arr = new JsonArray();
                for (String s : data.getStringArray()) {
                    arr.add(s);
                }
                builder.add(data.getId(), (JsonElement)arr);
                data.setSetter(list -> {
                    JsonArray overwrite = new JsonArray();
                    for (String s : (List)list) {
                        overwrite.add(s);
                    }
                    builder.add(data.getId(), (JsonElement)overwrite);
                    data.setStringArray(((List)list).toArray(new String[0]));
                });
                break;
            }
            default: {
                throw new IllegalAccessException("Unknown property type.");
            }
        }
    }
}

