/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class BlockStateAdapter
extends TypeAdapter<class_2680> {
    public class_2680 read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return BlockStateAdapter.resolveBlockState(reader.nextString());
    }

    public void write(JsonWriter writer, class_2680 blockState) throws IOException {
        if (blockState == null) {
            writer.nullValue();
            return;
        }
        String blockString = String.valueOf(blockState);
        if (blockString.startsWith("Block")) {
            blockString = blockString.replace("Block", "");
        }
        blockString = blockString.replace("{", "");
        blockString = blockString.replace("}", "");
        writer.value(blockString);
    }

    public static class_2680 resolveBlockState(String fullString) {
        class_2680 blockState;
        HashMap<String, String> properties = new HashMap<String, String>();
        String blockString = fullString;
        int startIndex = fullString.indexOf(91);
        int stopIndex = fullString.indexOf(93);
        if (startIndex != -1) {
            blockString = fullString.substring(0, startIndex);
            if (stopIndex < startIndex) {
                YungsApiCommon.LOGGER.error("JSON: Malformed property {}. Missing a bracket?", (Object)fullString);
                YungsApiCommon.LOGGER.error("Using air instead...");
                return class_2246.field_10124.method_9564();
            }
            String currKey = "";
            StringBuilder currString = new StringBuilder();
            for (int index = startIndex + 1; index <= stopIndex; ++index) {
                char currChar = fullString.charAt(index);
                if (currChar == '=') {
                    currKey = currString.toString();
                    currString = new StringBuilder();
                    continue;
                }
                if (currChar == ',' || currChar == ']') {
                    properties.put(currKey, currString.toString());
                    currString = new StringBuilder();
                    continue;
                }
                currString.append(fullString.charAt(index));
            }
        }
        try {
            blockState = ((class_2248)((class_6880.class_6883)class_7923.field_41175.method_10223(class_2960.method_60654((String)blockString)).get()).comp_349()).method_9564();
        }
        catch (Exception e) {
            YungsApiCommon.LOGGER.error("JSON: Unable to read block '{}': {}", (Object)blockString, (Object)e.toString());
            YungsApiCommon.LOGGER.error("Using air instead...");
            return class_2246.field_10124.method_9564();
        }
        if (!properties.isEmpty()) {
            blockState = BlockStateAdapter.getConfiguredBlockState(blockState, properties);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> class_2680 getConfiguredBlockState(class_2680 blockState, Map<String, String> properties) {
        class_2248 block = blockState.method_26204();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            boolean found = false;
            for (class_2769 p : blockState.method_28501()) {
                class_2769 property = p;
                if (!property.method_11899().equals(key)) continue;
                Comparable val = property.method_11900(value).orElse(null);
                if (val == null) {
                    YungsApiCommon.LOGGER.error("JSON: Found null for property {} for block {}", (Object)property, (Object)class_7923.field_41175.method_10206((Object)block));
                    continue;
                }
                blockState = (class_2680)blockState.method_11657(property, val);
                found = true;
                break;
            }
            if (found) continue;
            YungsApiCommon.LOGGER.error("JSON: Unable to find property {} for block {}", (Object)key, (Object)class_7923.field_41175.method_10206((Object)block));
        }
        return blockState;
    }
}

