/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.api.autoregister;

import com.google.common.collect.ImmutableSet;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterEntry;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_10162;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4048;
import net.minecraft.class_5132;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7696;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7924;

public class AutoRegisterEntityType<T extends class_1297>
extends AutoRegisterEntry<class_1299<T>> {
    private Supplier<class_5132.class_5133> attributesBuilderSupplier;

    public static <U extends class_1297> AutoRegisterEntityType<U> of(Supplier<class_1299<U>> entityTypeSupplier) {
        return new AutoRegisterEntityType(entityTypeSupplier);
    }

    public AutoRegisterEntityType<T> attributes(Supplier<class_5132.class_5133> attributesBuilderSupplier) {
        this.attributesBuilderSupplier = attributesBuilderSupplier;
        return this;
    }

    public boolean hasAttributes() {
        return this.attributesBuilderSupplier != null;
    }

    public Supplier<class_5132.class_5133> getAttributesSupplier() {
        return this.attributesBuilderSupplier;
    }

    private AutoRegisterEntityType(Supplier<class_1299<T>> entityTypeSupplier) {
        super(entityTypeSupplier);
    }

    public static class Builder<T extends class_1297> {
        private final class_1299.class_4049<T> factory;
        private final class_1311 category;
        private ImmutableSet<class_2248> immuneTo = ImmutableSet.of();
        private boolean serialize = true;
        private boolean summon = true;
        private boolean fireImmune;
        private boolean canSpawnFarFromPlayer;
        private int clientTrackingRange = 5;
        private int updateInterval = 3;
        private float spawnDimensionsScale = 1.0f;
        private class_4048 dimensions = class_4048.method_18384((float)0.6f, (float)1.8f);
        private class_7699 requiredFeatures = class_7701.field_40182;
        private class_10162<class_1299<?>, String> descriptionId;
        private class_10162<class_1299<?>, Optional<class_5321<class_52>>> lootTable;

        private Builder(class_1299.class_4049<T> entityFactory, class_1311 mobCategory) {
            this.factory = entityFactory;
            this.category = mobCategory;
            this.canSpawnFarFromPlayer = mobCategory == class_1311.field_6294 || mobCategory == class_1311.field_17715;
            this.lootTable = resourceKey -> Optional.of(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)resourceKey.method_29177().method_45138("entities/")));
            this.descriptionId = resourceKey -> class_156.method_646((String)"entity", (class_2960)resourceKey.method_29177());
        }

        public static <T extends class_1297> Builder<T> of(class_1299.class_4049<T> entityFactory, class_1311 mobCategory) {
            return new Builder<T>(entityFactory, mobCategory);
        }

        public Builder<T> sized(float width, float height) {
            this.dimensions = class_4048.method_18384((float)width, (float)height);
            return this;
        }

        public Builder<T> noSummon() {
            this.summon = false;
            return this;
        }

        public Builder<T> noSave() {
            this.serialize = false;
            return this;
        }

        public Builder<T> fireImmune() {
            this.fireImmune = true;
            return this;
        }

        public Builder<T> immuneTo(class_2248 ... blocks) {
            this.immuneTo = ImmutableSet.copyOf((Object[])blocks);
            return this;
        }

        public Builder<T> canSpawnFarFromPlayer() {
            this.canSpawnFarFromPlayer = true;
            return this;
        }

        public Builder<T> spawnDimensionsScale(float scale) {
            this.spawnDimensionsScale = scale;
            return this;
        }

        public Builder<T> clientTrackingRange(int chunkRange) {
            this.clientTrackingRange = chunkRange;
            return this;
        }

        public Builder<T> updateInterval(int interval) {
            this.updateInterval = interval;
            return this;
        }

        public Builder<T> requiredFeatures(class_7696 ... $$0) {
            this.requiredFeatures = class_7701.field_40180.method_45390($$0);
            return this;
        }

        public Builder<T> noLootTable() {
            this.lootTable = class_10162.fixed(Optional.empty());
            return this;
        }

        public class_1299<T> build(class_5321<class_1299<?>> resourceKey) {
            return new class_1299(this.factory, this.category, this.serialize, this.summon, this.fireImmune, this.canSpawnFarFromPlayer, this.immuneTo, this.dimensions, this.spawnDimensionsScale, this.clientTrackingRange, this.updateInterval, (String)this.descriptionId.get(resourceKey), (Optional)this.lootTable.get(resourceKey), this.requiredFeatures);
        }
    }
}

